local pn=...;
local t=Def.ActorFrame{};

local RadarPrm={"Stream","Chaos","Freeze","Air","Voltage"};
local r_str_x=0;
local r_str_y=0;
local r_vol_x=0;
local r_vol_y=0;
local r_cha_x=0;
local r_cha_y=0;
local r_frz_x=0;
local r_frz_y=0;
local r_air_x=0;
local r_air_y=0;
local radar_x={0,0,0,0,0,0,0,0,0,0};
local radar_y={0,0,0,0,0,0,0,0,0,0};
local keymode=false;

t[#t+1]=Def.ActorFrame{
	PlayerJoinedMessageCommand=cmd(playcommand,"Joined");
	OnCommand=cmd(playcommand,"Joined");
	LoadActor("_GrooveRadar base")..{
		InitCommand=function(self)
			self:diffuse(PlayerColor(pn));
			self:diffusealpha(1.0);
		end;
		JoinedCommand=function(self)
			self:player(pn);
		end;
	};
	LoadActor("_GrooveRadar over")..{
		InitCommand=function(self)
			self:diffuse(PlayerColor(pn));
			self:diffusealpha(1.0);
			self:blend('BlendMode_Add');
		end;
		JoinedCommand=function(self)
			self:player(pn);
		end;
	};

};
t[#t+1]=Def.ActorFrame{
	InitCommand=cmd(playcommand,"Joined");
	PlayerJoinedMessageCommand=cmd(queuecommand,"Joined";);
	LoadActor("_GrooveRadar autogen")..{
		JoinedCommand=function(self)
			self:player(pn);
			self:diffuse(PlayerColor(pn));
			self:playcommand("Changed");
		end;
		ChangedCommand=function(self)
			if step then
				if step:IsAutogen() then
					self:stoptweening();
					self:x((pn==PLAYER_1) and -42 or 42);
					self:y(-55);
					self:zoomy(1);
					--self:blend("BlendMode_Add")
					self:glowblink();
					self:effectperiod(0.80);
					self:visible(1);
				else
					self:visible(0);
				end;
			else
				self:visible(0);
			end;
		end;
	};
	Def.Actor{
		PlayerJoinedMessageCommand=function(self)
			self:player(pn);
			self:playcommand("Changed");
		end;
		ChangedCommand=function(self)
			local song=GAMESTATE:GetCurrentSong();
			--radarSet(self, PLAYER_1);
			if song then
				local dif=GAMESTATE:GetCurrentSteps(pn):GetDifficulty();
				local smexp_gr="";--GetSMParameter(song,"GR"..ToEnumShortString(dif));
				local l=0.80;
				for i=1,5 do
					if smexp_gr=="" then
						radar_x[i]=yaGetRadarVal(song,pn,RadarPrm[i],false) *l*math.sin(2*math.pi*(i-1)/5);
						radar_y[i]=yaGetRadarVal(song,pn,RadarPrm[i],false) *l*math.cos(2*math.pi*(i-1)/5)*(-1);
					else
						-- [ja] 自分で自由にレーダー値を設定（足譜のみ） 
						-- [ja] 不正ファイルの対策していないので非公開機能 
						-- [ja] SMファイルはSTR,VOL,AIR,FRZ,CHAの順だが、 
						--      STR,CHA,FRZ,AIR,VOLの順で指定する必要があるので注意 
						local smexp_gr_s=tonumber(split(',',smexp_gr)[i]);
						if smexp_gr_s>=0 then
							radar_x[i]=math.max(smexp_gr_s*100,5) *l*math.sin(2*math.pi*(i-1)/5);
							radar_y[i]=math.max(smexp_gr_s*100,5) *l*math.cos(2*math.pi*(i-1)/5)*(-1);
						else
							radar_x[i]=yaGetRadarVal(song,pn,RadarPrm[i],false) *l*math.sin(2*math.pi*(i-1)/5);
							radar_y[i]=yaGetRadarVal(song,pn,RadarPrm[i],false) *l*math.cos(2*math.pi*(i-1)/5)*(-1);
						end;
					end;
				end;
				for i=1,5 do
				radar_x[i+5]= yaGetRadarVal(song,pn,RadarPrm[i],true) *l*math.sin(2*math.pi*(i-1)/5);
				radar_y[i+5]= yaGetRadarVal(song,pn,RadarPrm[i],true) *l*math.cos(2*math.pi*(i-1)/5)*(-1);
				end;
				keymode=yaGetKeyMode(song);
			else
				for i=1,10 do
					radar_x[i]=0;
					radar_y[i]=0;
				end;
				keymode=false;
			end;
		end;
	};
};

local radar_name={"STR","CHA","FRZ","AIR","VOL"};
for i=1,5 do
t[#t+1]=Def.ActorFrame{
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:player(pn);
			self:x(55.0*math.sin(2*math.pi*(i-1)/5));
			self:y(55.0*math.cos(2*math.pi*(i-1)/5)*(-1));
			self:rotationz(360*(i-1)/5);
			self:diffuse(Color("Black"));
			self:settextf("%s",radar_name[i]);
			self:diffusealpha(0);
			self:zoom(0);
			self:sleep(_TT.S_IN);
		end;
		JoinedCommand=function(self)
			self:decelerate(0.2);
			self:diffusealpha(0.5);
			self:zoom(0.5);
		end;
		OnCommand=cmd(playcommand,"Joined");
		PlayerJoinedMessageCommand=cmd(queuecommand,"Init";queuecommand,"Joined");
	};
};
end;
for i=1,10 do
t[#t+1]=Def.ActorFrame{
	PlayerJoinedMessageCommand=cmd(playcommand,"On");
	Def.Quad{
		OnCommand=function(self)
			self:player(pn);
			self:queuecommand("Changed");
		end;
		ChangedCommand=function(self)
			if GAMESTATE:GetCurrentSong()
				and GAMESTATE:IsPlayerEnabled(pn) then
				self:stoptweening();
				self:linear(0.150);
				local x;
				local y;
				if i>5 then
					x=radar_x[i]-radar_x[i%5+6];
					y=radar_y[i]-radar_y[i%5+6];
				else
					x=radar_x[i]-radar_x[i%5+1];
					y=radar_y[i]-radar_y[i%5+1];
				end;
				local r=1.0*math.atan2(y,x)*180.0/math.pi;
				local l=math.sqrt(x*x+y*y);
				self:zoomto(l,1.8);
				if i>5 then
					self:diffuse(Color("Black"));
					self:diffusealpha(0.33);
					self:x((radar_x[i]+radar_x[i%5+6])/2);
					self:y((radar_y[i]+radar_y[i%5+6])/2);
				else
					self:diffuse(BoostColor(PlayerColor(pn)
						,(pn==PLAYER_1) and 2.5 or 1.8));
					self:diffusealpha(1);
					self:x((radar_x[i]+radar_x[i%5+1])/2);
					self:y((radar_y[i]+radar_y[i%5+1])/2);
				end;
				self:rotationz(r);
				self:visible(1);
			else
				self:visible(0);
			end;
		end;
	};
};
end;

local old_step=nil;
local function update(self)
	if _SONG() then
		local st=_STEPS2(pn);
		if old_step~=st then
			old_step=st;
			self:playcommand("Changed");
		end;
	else
		if old_step~=nil then
			old_step=nil;
			self:playcommand("Changed");
		end;
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,update);

return t;